---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-Executor Thread Dump（エグゼキュータスレッドダンプ）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **RPC呼び出しタイムアウト設定の詳細**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorThreadDumpPage.scala` 行31-184
- E-02: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` 行27-46
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` No.11
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` No.11
- E-05: `docs/code-to-docs/画面遷移図.md` ExecutorsTab遷移
- E-06: `core/src/main/scala/org/apache/spark/internal/config/UI.scala` UI_THREAD_DUMPS_ENABLED, UI_FLAMEGRAPH_ENABLED

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは/executors/threadDump/ | E-01 行33: WebUIPage("threadDump") | ○ |
| C-02 | executorIdパラメータが必須 | E-01 行38-42: パラメータ取得とIllegalArgumentException | ○ |
| C-03 | スレッドダンプサマリーテーブルを表示 | E-01 行158-182: threadDumpSummaryメソッド | ○ |
| C-04 | サマリーにThread State/Count/Percentageを表示 | E-01 行168-178: thead/tbody生成コード | ○ |
| C-05 | フレイムグラフはspark.ui.flamegraph.enabled設定で制御 | E-01 行35: UI_FLAMEGRAPH_ENABLED, 行77-81 | ○ |
| C-06 | フレイムグラフはD3.jsとd3-flamegraph.min.jsを使用 | E-01 行148-152: script/linkタグ | ○ |
| C-07 | Thread ID/Name/State/Locksの4列テーブル | E-01 行110-120: theadカラム定義 | ○ |
| C-08 | スタックトレースは行クリックで展開 | E-01 行62: onclick=toggleThreadStackTrace | ○ |
| C-09 | Expand All/Collapse Allボタンがある | E-01 行93-94: expandAllThreadStackTrace/collapseAllThreadStackTrace | ○ |
| C-10 | 検索ボックスでフィルタリング可能 | E-01 行101: oninput=onSearchStringChange | ○ |
| C-11 | ダウンロード機能がある | E-01 行95: downloadリンクとdata URIスキーム | ○ |
| C-12 | SparkContext.getExecutorThreadDumpで取得 | E-01 行44: sc.get.getExecutorThreadDump(executorId) | ○ |
| C-13 | エラー時に"Error fetching thread dump"を表示 | E-01 行125: getOrElse(Text("Error fetching thread dump")) | ○ |
| C-14 | threadDumpEnabled設定で画面の有効/無効が決まる | E-02 行32-39: UI_THREAD_DUMPS_ENABLEDでattachPage制御 | ○ |
| C-15 | Executors一覧から遷移 | E-05: ExecutorsPage --> ExecutorThreadDump | ○ |
| C-16 | Stage Detailからも遷移可能 | E-05: StageDetail --> ExecutorThreadDump | ○ |
| C-17 | ページ上部に取得時刻を表示 | E-01 行75: UIUtils.formatDate(time) | ○ |
| C-18 | RPC呼び出しタイムアウトの詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- RPC呼び出しタイムアウトの具体的な設定値と挙動について、SparkContext内部のRPC実装を確認する必要がある
  - 候補：SparkContext.scala / SparkEnv.scala / RpcEndpointRef設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面表示項目・イベント仕様はソースコードと一致している
- 1: 中リスク - RPC通信失敗時の詳細な挙動はSparkContext内部実装に依存

## 6) レビュアーチェックリスト（最小）
- [ ] スレッドダンプ取得失敗時のエラーメッセージが実際の画面表示と一致するか確認
- [ ] フレイムグラフ機能のデフォルト設定値（false）が正しいか確認
- [ ] ACL設定による閲覧制限の記述が運用環境と一致するか確認
